Option Explicit On

Public Module TelephoneCheck


    '//--y VB.net ڐA TelephoneCheck_VBnet.vb (Ver 1.00 , |e[u:2022/7/1 )  z---------------------------
    '//
    '//  dbԍ̃nCt/ҏW֐ ( ValidateTelephone / FormatTelephone / GetTypeTelephone )
    '//
    '// y ڐA\[XFԍ|e[u  TelephoneCheck.js z
    '//
    '//   Tips29: JavaScriptœdbԍiǔԁj̃nCt/ҏW
    '//   http://addinbox.sakura.ne.jp/Excel_Tips29.htm
    '//
    '//   Author : AddinBox(pc) http:'//addinbox.sakura.ne.jp/
    '//
    '//     1.00 , 2019/ 2/14 (JavaScript )
    '//     4.40 , 2019/ 3/27 (JavaScript)
    '//     4.40 , 2019/ 3/31 (VB.net ڐA)
    '//   - - - - - - - - - - - -
    '//   Ver 1.00 , 2019/ 4/ 4 (VB.net ڐA, ԍ|e[u:2019/4/1 )
    '//   Ver 1.00 , 2019/ 5/ 9 (VB.net ڐA, ԍ|e[u:2019/5/7 )
    '//   Ver 1.00 , 2020/ 7/20 (VB.net ڐA, ԍ|e[u:2020/6/1 )
    '//   Ver 1.00 , 2022/ 8/ 2 (VB.net ڐA, ԍ|e[u:2022/7/1 )
    '//
    '//   *1 Œdbԍ͔ԍ|e[uɂāAS̎sOǔԂ𒉎ɔ肵܂B
    '//      LŖ|e[u̎dg݂mFł܂B
    '//          [ dbԍ|e[u |V~[^[ ]
    '//            http://addinbox.sakura.ne.jp/Excel_Tips29.htm#S2_2
    '//-------------------------------------------------------------------------------
    '//   y T|[gĂdbԍ z
    '//       Œdb       10(擪 0) [ 0ABCDE-FGHJ ]
    '//       gѓdb       11(擪 070/080/090) [ 0x0-CDEF-GHJK , C:1-9 ] :060͎{
    '//       Mۋ       10(擪 0120) [ 0120-DEF-GHJ ]
    '//       Mۋ       11(擪 0800) [ 0800-DEF-GHJK ]
    '//       hodb       11(擪 050)  [ 050-CDEF-GHJK , C:1-9 ]
    '//       lQl         11(擪 020x) [ 020-CDE-FGHJK , C:1-3,5-9 ]
    '//       |Px       11(擪 0204) [ 020-4DE-FGHJK ]
    '//       elb         11(擪 0600) [ 0600-DEF-GHJK ]
    '//       񗿑㗝 10(擪 0990) [ 0990-DEF-GHJ ]
    '//       Sԍ   10(擪 0570) [ 0570-DEF-GHJ ]
    '//-------------------------------------------------------------------------------


    '// ԍ|e[u(2022/7/1 )
    '//   Œdb̑S̋ǔ(sOǔԁ{sǔ)ьgѓdb(070/080/090)̋ǔԂ
    '//   ^ĂJSONt@C(AreaCode4JSON.json)Kvŏ̓eɕҏWĂ܂B
    '//   Sł̃tH[}bg [ http://addinbox.sakura.ne.jp/Excel_Tips29.htm ] QƂ̎B
    '//   AVB.netpf[^JSONt@C쐬c[ňꏏɍ쐬Ă܂̂ŁA
    '//  uzf[^v̓ꐫ/m͕ۏႵ܂B
    '//
    Private AreaCodeArray( , ) = {
        {0,1,22,41,42,54,69,70,81,114},          {0,-3,2,4,7,10,15,19,20,21},                      {-103,0,0,-4,-4,-4,3,0,0,0}, _
        {0,0,-4,-4,-4,-4,-4,-5,0,0},             {0,0,0,-4,-4,-4,-4,5,-4,6},                       {0,0,-5,0,-5,-4,-4,-5,-4,0}, _
        {0,0,-5,-4,-4,-4,-4,-5,-5,0},            {0,0,-4,-4,-4,8,9,0,0,0},                         {0,0,-4,-4,-4,0,-5,-5,0,0}, _
        {0,0,-4,-4,-4,-4,-5,0,0,0},              {0,0,-4,-4,11,12,13,-4,14,0},                     {0,0,-4,-4,-4,-4,-4,-5,-3,-4}, _
        {0,-3,-4,-4,-4,-4,-4,-3,-5,-4},          {0,0,-4,-4,-5,0,-4,-4,0,0},                       {0,0,-4,-4,-4,-4,-5,-5,-4,0}, _
        {0,0,-4,16,17,18,-4,-4,0,0},             {0,0,-5,0,-5,-5,-4,0,-4,-4},                      {0,0,-4,-4,-4,-4,-4,0,-5,0}, _
        {0,0,-4,-4,-5,-5,-5,0,-5,0},             {0,0,-4,-4,-4,-4,-4,-3,-4,-4},                    {0,0,-4,-4,-4,-4,-4,-4,-3,0}, _
        {0,-4,-4,-4,-4,-4,-3,-4,-4,-3},          {130,0,23,25,26,27,32,34,36,39},                  {-4,0,-3,24,-4,-4,-4,-3,-4,-4}, _
        {-3,0,-4,-4,-3,-3,-3,-3,-3,-3},          {0,0,0,-4,-4,-4,-3,-4,-4,0},                      {-4,-4,-4,-4,-4,-3,-4,-4,-4,-3}, _
        {-4,0,-3,-3,-4,28,29,30,31,-4},          {-3,-3,-3,-3,-3,-3,-3,-4,-4,-3},                  {-3,0,0,-4,-4,-4,-4,-4,-4,-4}, _
        {-3,-3,-4,-4,-4,-3,-3,-3,-3,-3},         {-3,0,-4,-4,-4,-4,-4,-4,-4,-4},                   {-4,-4,-3,-4,33,-4,-4,-4,-4,-4}, _
        {-3,0,-4,-4,-4,-4,-3,-3,-3,0},           {-4,0,-3,-3,-4,0,-4,-4,35,-4},                    {0,0,-4,-4,0,-4,-4,-4,-3,-3}, _
        {-4,0,-4,37,-4,-4,-3,-4,-4,38},          {-3,0,-4,-3,-3,-4,-4,0,-4,-4},                    {-3,0,0,0,0,-3,-4,-4,-4,-4}, _
        {0,-4,-3,40,-4,-4,-4,-4,-3,-4},          {-3,0,-4,-4,-4,-3,-3,0,-3,0},                     {0,0,0,-2,-2,-2,-2,0,0,0}, _
        {0,0,43,47,-3,-3,48,49,51,52},           {-2,0,44,-3,-3,-3,-3,-3,45,46},                   {-3,0,-4,-4,-4,-4,-4,-4,-4,-4}, _
        {-3,-3,-4,-4,-3,-3,-3,-4,-4,0},          {-2,-3,-2,-2,-2,-2,-2,-3,-3,-2},                  {0,0,-3,-3,-3,0,-4,0,-4,-4}, _
        {-4,0,-3,-4,-3,-4,-4,-4,-3,0},           {50,-2,0,-3,-3,-4,-4,-3,-4,-4},                   {-2,0,-4,-4,-4,-4,-4,-4,-4,-2}, _
        {-4,0,-3,0,-3,-3,-3,-3,-3,-3},           {0,0,-3,-4,-4,-4,0,0,0,53},                       {0,0,-5,0,-5,0,-5,0,-5,0}, _
        {131,0,-3,55,59,60,61,62,64,65},         {0,-4,-4,-4,-3,-3,-4,-4,-4,56},                   {0,0,-3,0,0,0,57,58,-3,0}, _
        {0,-4,-4,-4,-3,-3,-3,-3,-3,-3},          {0,0,0,-3,-4,0,0,-4,0,0},                         {0,0,-3,-3,-4,-4,-3,-4,-4,-3}, _
        {-4,-4,-3,-4,-4,-4,-4,-4,-4,-3},         {0,-4,-4,-4,-4,-4,-4,-4,-4,-4},                   {-110,0,-4,-4,-4,-4,63,-4,-4,0}, _
        {0,0,-4,-4,-4,-4,-4,-4,0,-5},            {0,-4,-3,-3,-4,-4,-4,-4,0,0},                     {0,0,-3,-3,-4,-4,-4,66,-4,68}, _
        {0,0,-4,-4,-4,0,0,-4,-4,67},             {0,0,-5,-5,-5,-5,-5,-4,-4,-5},                    {0,0,-4,-4,-4,-4,-4,-4,-4,-3}, _
        {132,0,0,0,-2,0,-2,-2,0,0},              {133,0,71,72,73,-3,75,76,-3,77},                  {0,-4,-3,-3,-3,-4,-3,-3,-3,-3}, _
        {0,0,0,0,-3,-4,-4,-4,-4,-4},             {-4,0,-4,-4,-4,-4,74,-4,-4,-4},                   {0,0,0,-4,-4,-4,-4,0,-5,0}, _
        {0,-4,-3,-4,-3,-4,-4,-4,-4,0},           {-4,-4,-4,-4,-4,-3,-4,0,-4,-4},                   {-4,-4,-3,-3,78,79,80,-4,-4,-4}, _
        {0,0,-3,-3,-3,-3,-4,-4,-4,-3},           {-3,0,-4,-4,-4,-3,-3,-4,-4,-3},                   {-3,0,-4,-4,-4,-4,-3,-3,-4,-4}, _
        {134,0,82,87,94,96,98,111,112,113},      {-4,0,-3,-4,83,-3,-4,-4,-3,84},                   {-3,0,-3,-3,-4,-4,-4,-4,-4,-3}, _
        {-3,0,85,-4,86,-4,-3,-4,-4,0},           {-4,-3,-3,-3,-3,-3,-3,-3,-3,-3},                  {-4,-3,-3,-3,-4,-4,0,0,0,0}, _
        {0,0,-3,-4,-4,-4,88,89,91,92},           {-3,0,-4,-4,-4,-4,-4,-4,-4,-4},                   {0,0,-4,-4,-4,-4,90,-3,-3,0}, _
        {-4,0,-4,-4,-4,-4,-3,-3,-3,-4},          {0,0,-4,-4,-4,-4,0,-5,-5,0},                      {-3,0,-3,-3,-3,-3,93,-3,-3,-3}, _
        {0,0,-5,-3,0,-5,-3,-5,-5,0},             {0,0,0,0,0,-4,-4,95,-4,-3},                       {0,0,-4,-4,-4,-4,-4,-5,-4,0}, _
        {0,97,-4,-4,-4,-4,-4,-4,-4,-4},          {0,0,-5,0,-5,0,0,0,0,0},                          {0,0,-3,99,-3,101,103,105,108,109}, _
        {0,0,-4,-4,-4,-4,100,-4,-4,0},           {0,0,-3,-3,-3,0,-4,0,-3,0},                       {0,0,-3,0,-4,102,-4,-4,0,0}, _
        {-4,0,-3,0,-4,0,0,0,-4,0},               {-3,0,-4,-4,-4,-4,-4,-4,-4,104},                  {-4,-3,-4,-4,-4,-4,-4,-3,-3,-4}, _
        {0,0,106,107,-4,-4,-4,-4,-4,-4},         {0,0,-3,-3,-3,-4,-3,-4,-3,0},                     {0,0,0,-4,-4,-4,-4,-3,-3,0}, _
        {-3,0,-4,-4,-4,-4,-4,-4,-4,-3},          {-3,0,-4,-4,-3,-3,-4,-4,-4,110},                  {0,0,-4,-4,0,-3,0,-3,0,-3}, _
        {0,0,0,0,0,-4,0,-4,-3,-4},               {-4,0,0,-4,-4,-4,-3,-4,-3,-4},                    {0,0,-4,-4,-4,-4,-4,-4,-4,-3}, _
        {135,0,115,116,117,118,119,120,121,123}, {-4,0,-3,-3,-3,-3,-3,-3,-3,-3},                   {-4,0,-3,-3,-3,-3,-3,-3,-3,-3}, _
        {-4,0,-4,-4,-4,0,-4,-4,-4,-4},           {-4,0,-4,0,-4,-4,-4,-4,-3,-4},                    {0,0,-3,-3,-4,-4,-4,-4,-4,-4}, _
        {0,0,-4,-4,-4,-3,0,-4,-4,-4},            {122,0,-4,-4,-4,-4,-4,-4,-3,-3},                  {0,0,-5,-4,-4,-4,-4,-4,-4,-4}, _
        {-109,124,-3,125,128,-4,129,-4,-3,0},    {0,0,-5,-5,0,0,0,0,0,0},                          {0,0,-4,126,127,-4,-4,-4,-4,0}, _
        {0,-3,-4,-4,-4,-4,-4,-4,-4,-4},          {-4,-4,0,-3,0,-3,0,-3,0,-4},                      {-3,0,-4,-4,-4,-4,-4,-3,-3,-4}, _
        {0,0,-4,-4,-4,-4,-4,-4,-4,-5},           {0,-106,-106,-106,-107,-106,-106,-106,-106,-106}, {0,-105,-105,-105,-105,-105,-105,-105,-105,-105}, _
        {-108,0,0,0,0,0,0,0,0,0},                {0,-102,-102,-102,-102,-102,-102,-102,-102,-102}, {-104,-102,-102,-102,-102,-102,-102,-102,-102,-102}, _
        {0,-102,-102,-102,-102,-102,-102,-102,-102,-102}
 }


    '// ԋpl̍\̒`( ValidateTelephone , FormatTelephone )
    '// ϐ`ł New RXgN^[Dummy 0 w肷
    Public Structure TelephoneCheckValue
        Public TelType As Integer
        Public EditType As Integer
        Public TelEdit As String
        Public ErrId As Integer

        Public Sub New(ByVal Dummy As Integer)
            Me.TelType = -1
            Me.EditType = 9
            Me.TelEdit = ""
            Me.ErrId = 0
        End Sub
    End Structure

    '// ԋpl̍\̒`( GetTypeTelephone )
    '// ϐ`ł New RXgN^[Dummy 0 w肷
    Public Structure TelephoneType
        Public TelType As Integer
        Public SizeAll As Integer
        Public Size1 As Integer
        Public Size2 As Integer
        Public Size3 As Integer
        Public ErrId As Integer

        Public Sub New(ByVal Dummy As Integer)
            Me.TelType = -1
            Me.SizeAll = 0
            Me.Size1 = 0
            Me.Size2 = 0
            Me.Size3 = 0
            Me.ErrId = 0
        End Sub
    End Structure


    '//-------------------------------------------------------------------------------
    '// dbԍ̃tH[}bg ( PhoneNumber )
    '//    --- ValidateTelephone/FormatTelephone ̊ȈՃC^[tF[X ---
    '//
    '// TelCode -- p[ 0-9, -, (, ) ]
    '//            Œdb/gѓdbȂǂ[nCt/]ҏW or ҏWdbԍ
    '//
    '// EditType -- I[o[[hΏۂ̈ŁA1`6 ̐lw肵܂
    '//             w肵Ȃ : dbԍ̌ (Action="V")
    '//             w肷   : dbԍ̕ҏW (Action="F1"`"F6")
    '//               1or4: 0AB-CDE-FGHJ , 2or5: 0AB(CDE)FGHJ , 3or6: (0AB)CDE-FGHJ
    '//               gѓdb̂݁A[3-4-4 ]ŋ؂1`3 , [3-3-5 ]ŋ؂4`6
    '//
    '// ԋpl
    '//    Action= "V" -- ԋpl Integer^ł
    '//        0: ؃G[ , 1:OK , 2:OK(dbԍ̂)
    '//        (Boolean ϊ 0False, 1/2True ɂȂ܂)
    '//
    '//    Action= "F1"`"F6" -- ԋpl String^ł
    '//        dbԍꍇ     --  EditTypeɏ]ĕҏWdbԍ
    '//        dbԍĂꍇ --  "Phone Error""
    '//        EditType 1`6 ȊO     -- 󕶎("") (BooleanϊFalse)ŕԂ܂B
    '//
    '//-------------------------------------------------------------------------------
    Public Function PhoneNumber(ByVal TelCode As String) As Integer
        Return CInt(PhoneNumber_Core(TelCode, "V", 0))
    End Function

    Public Function PhoneNumber(ByVal TelCode As String, ByVal EditType As Integer) As String
        If (EditType >= 1) And (EditType <= 6) Then
            Return PhoneNumber_Core(TelCode, "F", EditType)
        Else
            Return String.Empty
        End If
    End Function

    Private Function PhoneNumber_Core(ByVal TelCode As String,
                                      ByVal Action As String, ByVal EditType As Integer) As String
        '// FormatTelephone/ValidateTelephone ̕ԋpl
        Dim Result As New TelephoneCheckValue(0)

        If (Action = "V") Then  '// ŕԂ PhoneNumber Őlϊ
            Result = ValidateTelephone(TelCode)
            Select Case Result.ErrId
                Case 0
                    Return "1"  '// OK(BooleanϊTrue)
                Case 8
                    Return "2"  '// OK (dbԍ̂, BooleanϊTrue)
                Case Else
                    Return "0"  '// G[(BooleanϊFalse)
            End Select
        Else
            Result = FormatTelephone(TelCode, EditType)
            If (Result.ErrId = 0) Then
                Return Result.TelEdit
            Else
                Return "Phone Error"
            End If
        End If
    End Function

    '//-------------------------------------------------------------------------------
    '// dbԍ̌ ( ValidateTelephone )
    '//
    '// TelCode -- p[ 0-9, -, (, ) ]
    '//            Œdb/gѓdbȂǂ[nCt/]ҏW
    '//
    '// ԋpl  -- {TelType, EditType, TelEdit, ErrId} ̘Azz
    '//   TelType   1:Œdb(10), 2:gѓdb(070/080/090,11), 3:Mۋ(0120,10),
    '//             4:Mۋ(0800,11), 5:IPdb(050,11), 6:M2M(020x,11,x4),
    '//             7:|Px(0204,11), 8:FMC(0600,11), 9:񗿒(0990,10),
    '//             10:ԍ(0570,10), -1:other
    '//
    '//   EditType  1or4: 0AB-CDE-FGHJ, 2or5: 0AB(CDE)FGHJ, 3or6: (0AB)CDE-FGHJ, 9:other
    '//             gѓdb̂݁A[3-4-4 ]ŋ؂1`3 , [3-3-5 ]ŋ؂4`6
    '//
    '//   TelEdit   TelType/EditType ŕҏWꂽdbԍ(ҏW)
    '//               ErrId=0/1/3/5 : p^[ŕҏWꂽdbԍ
    '//                 V =8       : nCtҏWdbԍ
    '//                 V =2       : TelCode ̂܂(gpǔԂȂ̂Ő͔fȂ)
    '//                 V =4/6/9   : 󕶎
    '//
    '//   ErrId     0:OK, 1:؂ʒus, 2:gpǔ(Œdb), 3:sǔ1ڂ[0 or 1](Œdb),
    '//             4:s([,nCt,]ȊO or ҏWp^[s or '0'n܂łȂ or s),
    '//             5:s(ǔԃ^Cvɉƕsv),
    '//             6:̑̃G[, 8:OK(̂ݎw), 9:`(TelCode)
    '//-------------------------------------------------------------------------------
    Public Function ValidateTelephone(ByVal TelCode As String) As TelephoneCheckValue


        Dim Result As New TelephoneCheckValue(0)         '// ԋpl
        Dim ResultFormat As New TelephoneCheckValue(0)   '// FormatTelephone̕ԋpl
        Dim ResultFormat2 As New TelephoneCheckValue(0)  '// gѓdb(3-3-5؂ҏW̍Ď擾p)

        Dim TelNumber As String    '// nCt,ʏ(̂)
        Dim EditType As Integer

        '// ȃ`FbN FormatTelephone ̌ʂƔrčsȂ̂
        '// L̃p^[`FbNł͌ɂĂ͞Bō\Ȃ('0'n܂̂݃`FbN)
        Dim Pattern0 As New System.Text.RegularExpressions.Regex("^0\d+$")              '// 0123456789
        Dim Pattern1 As New System.Text.RegularExpressions.Regex("^0\d+-\d+-\d+$")      '// 012-345-6789
        Dim Pattern2 As New System.Text.RegularExpressions.Regex("^0\d+\(\d+\)\d+$")    '// 012(345)6789
        Dim Pattern3 As New System.Text.RegularExpressions.Regex("^\(0\d+\)\d+-\d+$")   '// (012)345-6789

        If (Pattern0.IsMatch(TelCode) = True) Then  '// (̂)  0123456789
            '// ̂ݎw  ҏŴݍsĔr؂͖
            ResultFormat = FormatTelephone(TelCode, 1)  '// nCtҏWŌŒ
            Result.TelType = ResultFormat.TelType
            Result.EditType = 1
            Result.TelEdit = ResultFormat.TelEdit
            '// ValidateTephonepG[R[hɍւ
            Select Case ResultFormat.ErrId
                Case 0
                    Result.ErrId = 8  '// OK(̂ݎw)
                Case 1
                    Result.ErrId = 2  '// gpǔ(Œdbԍ)
                Case 2
                    Result.ErrId = 3  '// sǔ1ڂ[0 or 1](Œdb)
                Case 3
                    Result.ErrId = 4  '// s(10)
                Case 4
                    Result.ErrId = 5  '// ǔԃ^Cvɉƕsv
                Case Else
                    Result.ErrId = 6  '// ̑̃G[
            End Select
            Return Result

        ElseIf (Pattern1.IsMatch(TelCode) = True) Then  '// EditType:1  012-345-6789
            EditType = 1
            Result.EditType = 1
        ElseIf (Pattern2.IsMatch(TelCode) = True) Then  '// EditType:2 012(345)6789
            EditType = 2
            Result.EditType = 2
        ElseIf (Pattern3.IsMatch(TelCode) = True) Then  '// EditType:3 (012)345-6789
            EditType = 3
            Result.EditType = 3
        Else
            '// [,nCt,]ȊO or ҏWp^[s or '0'n܂łȂ
            Result.ErrId = 4
            Result.TelEdit = TelCode
            Return Result
        End If

        '// FormatTelephone p[nCt,]āû݁vɂ
        TelNumber = Replace(TelCode, "-"c, String.Empty)
        TelNumber = Replace(TelNumber, "("c, String.Empty)
        TelNumber = Replace(TelNumber, ")"c, String.Empty)


        ResultFormat = FormatTelephone(TelNumber, EditType)
        '// FormatTelephone ŕҏWʂƔrČ؂
        '// ErrId ŕԂ̂
        '//    0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb)
        '//    3:s(TelCode: 10),
        '//    4:s(TelCode: ǔԃ^Cv̌ƕsv)
        '// LԂ͊Ƀ`FbNςȂ̂ŁA̒lԂ邱Ƃ͖
        '//    3:s(TelCode: ['0'n܂̐]ȊO)
        '//    6:s(EditType)
        '//    9:`(TelCode/EditType)

        Result.TelType = ResultFormat.TelType
        Result.TelEdit = ResultFormat.TelEdit

        '// ValidateTephonepG[R[hɍւ
        Select Case ResultFormat.ErrId
            Case 0  '// FormatTelephoneOK  dbԍ
                If (TelCode = ResultFormat.TelEdit) Then
                    Result.ErrId = 0  '// OK (؂ʒu)
                Else
                    If (ResultFormat.TelType = 2) Then   '// gѓdb(070/080/090)
                        '// gѓdb̏ꍇAʂ̋؂[3-3-5 ]ōă`FbN
                        ResultFormat2 = FormatTelephone(TelNumber, EditType + 3)
                        If (TelCode = ResultFormat2.TelEdit) Then
                            '// OK (3-3-5ňv)
                            Result.ErrId = 0
                            Result.TelEdit = ResultFormat2.TelEdit
                            Result.EditType = EditType + 3
                        Else
                            Result.ErrId = 1  '// ؂ʒus
                        End If
                    Else
                        '// gѓdb ȊO
                        Result.ErrId = 1  '// ؂ʒus
                    End If
                End If
            Case 1
                Result.ErrId = 2  '// gpǔ(Œdbԍ)
                Result.TelEdit = TelCode  '// ResultFormat.TelEdit(=TelNumber)Ȃ̂œ͒lɍւ
            Case 2
                Result.ErrId = 3  '// sǔ1ڂ[0 or 1](Œdb)
            Case 3
                Result.ErrId = 4  '// s(10)
            Case 4
                Result.ErrId = 5  '// ǔԃ^Cvɉƕsv
            Case Else
                Result.ErrId = 6  '// ̑̃G[
        End Select

        Return Result
    End Function


    '//-------------------------------------------------------------------------------
    '// dbԍ̃nCtҏW ( FormatTelephone )
    '//
    '// TelCode  -- p[ 0-9 ], 10 or 11(擪'0'Œ)
    '//             Œdb/gѓdbȂǂ̓dbԍ
    '//
    '// EditType -- l
    '//             1or4: 0AB-CDE-FGHJ , 2or5: 0AB(CDE)FGHJ , 3or6: (0AB)CDE-FGHJ
    '//             gѓdb̂݁A[3-4-4 ]ŋ؂1`3 , [3-3-5 ]ŋ؂4`6
    '//
    '// ԋpl -- {TelType, EditType, TelEdit, ErrId} ̘Azz
    '//   TelType   1:Œdb(10), 2:gѓdb(070/080/090,11), 3:Mۋ(0120,10),
    '//             4:Mۋ(0800,11), 5:IPdb(050,11), 6:M2M(020x,11,x4),
    '//             7:|Px(0204,11), 8:FMC(0600,11), 9:񗿒(0990,10),
    '//             10:ԍ(0570,10), -1:other
    '//
    '//   EditType  1or4: 0AB-CDE-FGHJ, 2or5: 0AB(CDE)FGHJ, 3or6: (0AB)CDE-FGHJ, 9:other
    '//
    '//   TelEdit   ҏWꂽdbԍ
    '//               ErrId=0/2/4 : ҏWꂽdbԍ
    '//                V  =1     : TelCode ̓ê܂
    '//                V  =3/6/9 : 󕶎
    '//
    '//   ErrId     0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb),
    '//             3:s(TelCode: ['0'n܂̐]ȊO or 10),
    '//             4:s(TelCode: ǔԃ^Cvɉƕsv)
    '//             6:s(EditType), 9:`(TelCode/EditType)
    '//-------------------------------------------------------------------------------
    Public Function FormatTelephone(ByVal TelCode As String, ByVal EditType As Integer) As TelephoneCheckValue

        Dim Result As New TelephoneCheckValue(0)   '// ԋpl
        Dim ResultType As New TelephoneType(0)     '// GetTypeTelephone ԋpl

        Dim TelPattern As New System.Text.RegularExpressions.Regex("^0\d{9,}$")   '// '0'n܂̐(10ȏ)

        '// ['0'n܂̐(10ȏ)]̃`FbN
        '// (ԍ|(GetTypeTelephone)ɊSȌ`FbNsȂBł10̂NG)
        If (TelPattern.IsMatch(TelCode) = False) Then
            Result.ErrId = 3
            Return Result
        End If

        If ((EditType >= 1) And (EditType <= 6)) Then
            Result.EditType = EditType
        Else
            Return Result
        End If

        ResultType = GetTypeTelephone(TelCode)  '// ԍ|󂵂ēdbԍ̎ʂƌ؂擾
        '// ErrId ŕԂ̂
        '//    0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb)
        '// LԂ͊Ƀ`FbNςȂ̂ŁA̒lԂ邱Ƃ͖
        '//    3:dbԍʂs(sŔԍ|󖢗) 10ȏȂ̂Ŗ͖
        '//    8:s(TelCode: ['0'n܂̐]ȊO)
        '//    9:`(TelCode)

        Result.TelType = ResultType.TelType
        Result.ErrId = ResultType.ErrId
        If (ResultType.ErrId = 1) Then
            '// gpǔ(Œdb)
            Result.TelEdit = TelCode
        Else
            '// 0:OK  or  2:sǔ1ڂ[0 or 1](Œdb)
            If ((ResultType.TelType = 2) And (EditType >= 4)) Then
                '// gѓdb(070/080/090)[3-3-5 ؂, 0x0-CDE-FGHJK]w肳ꂽꍇ
                Result.TelEdit = InsertSeparator(TelCode, EditType, 3, 3)
            Else
                '// gѓdb(3-4-4؂)܂߁A͕ԋplŋ؂p^[
                '// Œdbł[sOǔԌ/sǔԌ/Ҕԍ(4)]
                If (ResultType.Size2 = 0) Then
                    '// ŒdbŁAsǔԂȂ [ 0ABCDE-FGHJ ] (݁A̒n݂͑Ȃ)
                    Result.TelEdit = Left(TelCode, 6) & "-" & Mid(TelCode, 7)
                Else
                    Result.TelEdit = InsertSeparator(TelCode, EditType, ResultType.Size1, ResultType.Size2)
                End If
            End If

            If (TelCode.Length <> ResultType.SizeAll) Then
                Result.ErrId = 4  '// G[(ǔԃ^Cvɉƕsv)
            End If
        End If

        Return Result
    End Function

    Private Function InsertSeparator _
    (ByVal TelCode As String, ByVal EditType As Integer,
     ByVal Size1 As Integer, ByVal Size2 As Integer) As String

        Dim Result As String
        Dim EditCode1 As String
        Dim EditCode2 As String
        Dim EditCode3 As String

        EditCode1 = Left(TelCode, Size1)              '// 1st section FŒdbł͎sOǔ(擪'0')
        EditCode2 = Mid(TelCode, (Size1 + 1), Size2)  '// 2nd section FŒdbł͎sǔ
        EditCode3 = Mid(TelCode, (Size1 + Size2 + 1)) '// 3rd section FŒdbł͉Ҕԍ(܂Ŏo)

        Select Case EditType
            Case 1, 4  '// 0AB-CDE-FGHJ
                Result = EditCode1 & "-" & EditCode2 & "-" & EditCode3
            Case 2, 5  '// 0AB(CDE)FGHJ
                Result = EditCode1 & "(" & EditCode2 & ")" & EditCode3
            Case 3, 6  '// (0AB)CDE-FGHJ
                Result = "(" & EditCode1 & ")" & EditCode2 & "-" & EditCode3
            Case Else
                Result = String.Empty  '// ͎ۂɂ͖
        End Select

        Return Result
    End Function


    '//-------------------------------------------------------------------------------
    '// dbԍ^Cv̎擾 ( GetTypeTelephone )
    '//
    '// TelCode  -- p(2ȏ, 擪'0'Œ)
    '//             Œdb/gѓdbȂǂ̓dbԍ(r܂ł̓eł)
    '//
    '// ԋpl -- {TelType, SizeAll, Size1, Size2, Size3, ErrId} ̘Azz
    '//   TelType   1:Œdb(10), 2:gѓdb(070/080/090,11), 3:Mۋ(0120,10),
    '//             4:Mۋ(0800,11), 5:IPdb(050,11), 6:M2M(020x,11,x4),
    '//             7:|Px(0204,11), 8:FMC(0600,11), 9:񗿒(0990,10),
    '//             10:ԍ(0570,10), -1:other
    '//
    '//   SizeAll   ErrId=0/2 : TelType ɉdbԍ̌(10 or 11, Size1`3̍vl)
    '//             ErrId=1/3/8/9 : 0
    '//
    '//   Size1-3   ErrId=0/2 : TelType ɉdbԍ̋؂茅(Size1 ɂ͐擪'0'܂)
    '//             ErrId=1/3/8/9 : 0
    '//             (gѓdb(TelType=2)[3-4-4 ؂]݂̂ŕԂ)
    '//
    '//   ErrId     0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb),
    '//             3:dbԍʂs(sŔԍ|󖢗)
    '//             8:s(TelCode: ['0'n܂̐]ȊO), 9:`(TelCode)
    '//-------------------------------------------------------------------------------
    Public Function GetTypeTelephone(ByVal TelCode As String) As TelephoneType

        Dim Result As New TelephoneType(0)    '// ԋpl

        Dim AreaCodeLength As Integer
        Dim CityCodeLength As Integer
        Dim CityCode1 As String      '// sǔԂ1
        Dim idx As Integer
        Dim cnt As Integer
        Dim num As Integer
        Dim LinkValue As Integer
        Dim TelType As Integer
        Dim TelPattern As New System.Text.RegularExpressions.Regex("^0\d+$") '// '0'n܂̐(Ȃ)

        '// ( 1)Œdb       10 [ ؂͔ԍ|󌋉ʂɋ ]
        '// ( 2)gѓdb       11 [ 0x0-CDEF-GHJK , 070/080/090 ]
        '// ( 3)Mۋ       10 [ 0120-DEF-GHJ  ]
        '// ( 4)Mۋ       11 [ 0800-DEF-GHJK ]
        '// ( 5)hodb       11 [ 050-CDEF-GHJK ]
        '// ( 6)lQl         11 [ 020-CDE-FGHJK ]
        '// ( 7)|Px       11 [ 020-4DE-FGHJK ]
        '// ( 8)elb         11 [ 0600-DEF-GHJK ]
        '// ( 9)񗿑㗝 10 [ 0990-DEF-GHJ  ]
        '// (10)Sԍ   10 [ 0570-DEF-GHJ  ]
        '//  SizeInfo [SizeAll, Size1, Size2, Size3]
        Dim SizeInfo(,) = {
           {0, 0, 0, 0}, {10, 0, 0, 0}, {11, 3, 4, 4},
           {10, 4, 3, 3}, {11, 4, 3, 4}, {11, 3, 4, 4},
           {11, 3, 3, 5}, {11, 3, 3, 5}, {11, 4, 3, 4},
           {10, 4, 3, 3}, {10, 4, 3, 3}
        }

        '// ['0'n܂̐(Ȃ)]̃`FbN
        If (TelPattern.IsMatch(TelCode) = False) Then
            Result.ErrId = 8
            Return Result
        End If

        '//  ԍ|e[u\[XR[hɒɎ^Ă̂
        '//    jQuery ɂ JSONt@C̓ǂݍݏ͕KvȂB

        '// ԍ|e[uǔԏ(sOǔԂ̌ or [gєԍ ]TelType)擾B
        '// [TelCode]̒[ǔԌ ]󂯓Ă̂Łwԍ| rxł̃[vI(TelType= -1)B
        idx = 0
        TelType = -1
        AreaCodeLength = 0
        cnt = 2     '// VBA ł͕ʒu 1IW(AR[h͂Q, ER[h͂U)

        While ((cnt <= 6) And (cnt < TelCode.Length))  '// ԍ|e[uA`ER[ĥTi
            num = CInt(Mid(TelCode, cnt, 1))    '// dbԍ2ڈȍ~(1ڂ'0')o
            LinkValue = AreaCodeArray(idx, num)
            If (LinkValue = 0) Then   '// ԍ| I(Œdb gpǔ)
                TelType = 1
                AreaCodeLength = 0
                Exit While
            ElseIf (LinkValue < 0) Then  '// ԍ| I
                If (LinkValue > -100) Then
                    '// Œdb̎sOǔԌ(]l) ۂ̎^l[ -2 ` -5 ]
                    TelType = 1
                    AreaCodeLength = LinkValue * (-1)  '// sOǔ (擪 "0" ܂)
                Else
                    '// gѓdb TelTypel(]l - 100) ۂ̎^l[ -102 ` -110 ]
                    TelType = (LinkValue * (-1)) - 100
                End If
                Exit While
            Else  '// vXl
                idx = LinkValue  '// p(^l NextIndex)
            End If

            cnt = cnt + 1
        End While

        '// TelType ɉ؂ݒ肷
        '// Œdb(TelType=1)ł͎sOǔԌ(AreaCodeLength)ɏ]Đݒ肷
        '// Size1 ̒l[擪'0'܂]
        Result.TelType = TelType
        Select Case TelType
            Case -1
                '// dbԍʂs(sŔԍ|󖢗)
                Result.ErrId = 3
            Case 1
                '// Œdb
                If (AreaCodeLength = 0) Then  '// gp ǔ
                    Result.ErrId = 1
                ElseIf (AreaCodeLength = 6) Then  '// sǔԂȂ [ 0ABCDE-FGHJ ] (݁A̒n݂͑Ȃ)
                    Result.ErrId = 0
                    Result.SizeAll = 10
                    Result.Size1 = 6
                    Result.Size2 = 0
                    Result.Size3 = 4
                Else
                    CityCodeLength = 6 - AreaCodeLength  '// 10 - AreaCodeLength - 4(Ҕԍ)
                    If (TelCode.Length < (AreaCodeLength + 1)) Then
                        '// [TelCode]sǔԂ̌ʒu܂łȂ̂ŎsǔԓKۂ̔s OK ŕԂ
                        Result.ErrId = 0
                    Else
                        '// FormatTelephone Ă΂ꍇ 10ȏȂ̂ŕK\
                        CityCode1 = Mid(TelCode, (AreaCodeLength + 1), 1)  '// sǔ 1
                        If ((CityCode1 = "0") Or (CityCode1 = "1")) Then
                            Result.ErrId = 2  '// sǔ1ڂ0/1͊蓖ĂȂ
                        Else
                            Result.ErrId = 0  '// OK
                        End If
                    End If
                    Result.SizeAll = 10
                    Result.Size1 = AreaCodeLength
                    Result.Size2 = CityCodeLength
                    Result.Size3 = 4
                End If
            Case Else
                '// TelType = 2`10, SizeInfoe[u猅ݒ肷
                Result.ErrId = 0  '// OK
                Result.SizeAll = SizeInfo(TelType, 0)
                Result.Size1 = SizeInfo(TelType, 1)
                Result.Size2 = SizeInfo(TelType, 2)
                Result.Size3 = SizeInfo(TelType, 3)
        End Select

        Return Result
    End Function

End Module

