#! ruby -EUTF-8
# -*- mode:ruby; coding:utf-8 -*-


## TelphoneCheck.rb  テスト ツール ##

module PhoneCheckTest

    require './TelephoneCheck'

    ans = ""
    arg = ""
    arg_list = ["",""]
    tel_code = ""   # テスト 電話番号

    result1 = TelephoneCheck.init_telephone('Type')
    result2 = TelephoneCheck.init_telephone('Value')
    result3 = TelephoneCheck.init_telephone('Value')
    result4 = TelephoneCheck.init_telephone('Value')
    result5 = ""

    print ("Test of PhoneNumber? (Y/N) > ")
    ans = gets.chomp
    if ((ans.upcase != "Y") && (ans.upcase != "N"))
        print("-- End of TelephoneCheck Test --\n\n")
        exit
    end

    if (ans.upcase == "Y")
        # コンソールで何も入力せずに即リターンしたら終了
        while (true)
            print ("PhoneNumber [ TelCode , Action ] > ")
            arg = gets.chomp  # 電話番号,Action をコンソール入力
            if  (arg == "")
                print("-- End of TelephoneCheck Test --\n\n")
                break;
            end
            arg_list = arg.split(",")
            if (arg_list.length != 2)
                print("Please enter [ TelCode , Action ]\n")
            else
                result5 = TelephoneCheck.phone_number(arg_list[0].strip, arg_list[1].strip)
                if (result5)
                    print("TRUE [ " + result5.to_s + " ]\n")
                else
                    print("FALSE [ " + result5.to_s + " ]\n")
                end
            end
        end
    else
        # コンソールで何も入力せずに即リターンしたら終了
        while (true)
            print("TelephoneCheck > ")
            tel_code = gets.chomp  # 電話番号をコンソール入力
            if (tel_code == "")
                print("-- End of TelephoneCheck Test --\n\n")
                break
            end

            result1 = TelephoneCheck.get_type_telephone(tel_code)
            # EditType  1: xx-xx-xx , 2: xx(xx)xx , 3: (xx)xx-xx
            result2 = TelephoneCheck.format_telephone(tel_code, 1)
            result3 = TelephoneCheck.validate_telephone(result2[:TelEdit])  # 編集電話番号
            result4 = TelephoneCheck.validate_telephone(tel_code)           # 数字のみ電話番号

            print("\n TelCode= [ " + tel_code.to_s + " ]" +
                "\n-- GetTypeTelephone --" +
                "\n TelType= " + result1[:TelType].to_s +
                "\n SizeAll= " + result1[:SizeAll].to_s +
                "\n Size1= "   + result1[:Size1].to_s +
                "\n Size2= "   + result1[:Size2].to_s +
                "\n Size3= "   + result1[:Size3].to_s +
                "\n ErrId= "   + result1[:ErrId].to_s +
                "\n\n-- FormatTelephone --" +
                "\n TelType= "  + result2[:TelType].to_s +
                "\n EditType= " + result2[:EditType].to_s +
                "\n TelEdit= "  + result2[:TelEdit].to_s +
                "\n ErrId= "    + result2[:ErrId].to_s +
                "\n\n-- ValidateTelephone [1] -- ( " + result2[:TelEdit].to_s + " )" +
                "\n TelType= "  + result3[:TelType].to_s +
                "\n EditType= " + result3[:EditType].to_s +
                "\n TelEdit= "  + result3[:TelEdit].to_s +
                "\n ErrId= "    + result3[:ErrId].to_s +
                "\n\n-- ValidateTelephone [2] -- ( " + tel_code.to_s + " )" +
                "\n TelType= "  + result4[:TelType].to_s +
                "\n EditType= " + result4[:EditType].to_s +
                "\n TelEdit= "  + result4[:TelEdit].to_s +
                "\n ErrId= "    + result4[:ErrId].to_s +
                "\n\n")
        end
    end
end  # of module
