#!/usr/bin/perl
use utf8;
use strict;
binmode STDOUT, ':encoding(UTF-8)';

## TelphoneCheck.pl  テスト ツール ##

require 'TelephoneCheck.pl';

my $Ans = "";
my $Arg = "";
my @ArgList = ("","");
my $TelCode = "";   # テスト 電話番号

my %Result1 = InitTelephone("Type");
my %Result2 = InitTelephone("Value");
my %Result3 = InitTelephone("Value");
my %Result4 = InitTelephone("Value");
my $Result5 = "";    # PhoneNumber


print STDOUT "Test of PhoneNumber? (Y/N) > ";
$Ans = <STDIN>;
chomp($Ans);
if ((uc($Ans) ne "Y") && (uc($Ans) ne "N")) {
    print STDOUT "-- End of TelephoneCheck Test --\n\n";
    exit;
}

if (uc($Ans) eq "Y") {
    # コンソールで何も入力せずに即リターンしたら終了
    while (1) {
        print STDOUT "PhoneNumber [ TelCode , Action ] > ";
        $Arg = <STDIN>;  # 電話番号,Action をコンソール入力
        chomp($Arg);
        if  ($Arg eq "") {
            print STDOUT "-- End of TelephoneCheck Test --\n\n";
            last;
        }
        @ArgList = split(/,/, $Arg);
        if ($#ArgList != 1) {
            print STDOUT "Please enter [ TelCode , Action ]\n";
        } else {
            $ArgList[0] =~ s/^\s*(.*?)\s*$/$1/;  # Trim
            $ArgList[1] =~ s/^\s*(.*?)\s*$/$1/;  # Trim
            $Result5 = PhoneNumber($ArgList[0], $ArgList[1]);
            if ($Result5) {
                print STDOUT "True [ " . $Result5 . " ]\n";
            } else {
                print STDOUT "False [ " . $Result5 . " ]\n";
            }
        }
    }
} else {
    # コンソールで何も入力せずに即リターンしたら終了
    while (1) {
        print STDOUT "TelPhoneCheck [ TelCode ] > ";
        $TelCode = <STDIN>;  # 電話番号をコンソール入力
        chomp($TelCode);
        if  ($TelCode eq "") {
            print STDOUT "-- End of TelephoneCheck Test --\n\n";
            last;
        }
        
        %Result1 = GetTypeTelephone($TelCode);
        # EditType  1: xx-xx-xx , 2: xx(xx)xx , 3: (xx)xx-xx
        %Result2 = FormatTelephone($TelCode, 1);
        %Result3 = ValidateTelephone($Result2{TelEdit});  # 編集電話番号
        %Result4 = ValidateTelephone($TelCode);           # 数字のみ電話番号

        print STDOUT ("\n TelCode= [ " . $TelCode . " ]" .
                      "\n-- GetTypeTelephone --" .
                      "\n TelType= " . $Result1{TelType} .
                      "\n SizeAll= " . $Result1{SizeAll} .
                      "\n Size1= "   . $Result1{Size1} .
                      "\n Size2= "   . $Result1{Size2} .
                      "\n Size3= "   . $Result1{Size3} .
                      "\n ErrId= "   . $Result1{ErrId} .
                      "\n\n-- FormatTelephone --" .
                      "\n TelType= "  . $Result2{TelType} . 
                      "\n EditType= " . $Result2{EditType} .
                      "\n TelEdit= "  . $Result2{TelEdit} .
                      "\n ErrId= "    . $Result2{ErrId} .
                      "\n\n-- ValidateTelephone [1] -- ( " . $Result2{TelEdit} . " )" .
                      "\n TelType= "  . $Result3{TelType} . 
                      "\n EditType= " . $Result3{EditType} .
                      "\n TelEdit= "  . $Result3{TelEdit} .
                      "\n ErrId= "    . $Result3{ErrId} .     
                      "\n\n-- ValidateTelephone [2] -- ( " . $TelCode . " )" .
                      "\n TelType= "  . $Result4{TelType} . 
                      "\n EditType= " . $Result4{EditType} .
                      "\n TelEdit= "  . $Result4{TelEdit} .
                      "\n ErrId= "    . $Result4{ErrId} .
                      "\n\n");
    }
}

              
