//-------------------------------------------------------------------------------
//  dbԍ̃nCt/ҏW֐ 
//  ( ValidateTelephone / FormatTelephone / GetTypeTelephone / PhoneNumber )
//
// y ԍ|e[u  TelephoneCheck.js  (Ver 1.00 , |e[u:2022/7/1 ) z
//
//   Tips29: JavaScriptœdbԍiǔԁj̃nCt/ҏW
//   http://addinbox.sakura.ne.jp/Excel_Tips29.htm
//
//   Author : AddinBox(pc) http://addinbox.sakura.ne.jp/
//
//     1.00 , 2019/ 2/14
//     4.40 , 2019/ 3/27
//   - - - - - - - - - - - -
//   Ver 1.00 , 2019/ 4/ 4  (ԍ|e[u:2019/4/1 )
//   Ver 1.00 , 2019/ 5/11  (ԍ|e[u:2019/5/7  [ 025-60x , 025-80x ̋ǔԒǉ ] )
//   Ver 1.00 , 2020/ 7/20  (ԍ|e[u:2020/6/1 )
//   Ver 1.00 , 2022/ 8/ 2  (ԍ|e[u:2022/7/1 )
//
//   *1 jQuery ͎gpĂ܂B
//      ԍ|e[u(2019/4/1 )̃f[^𒼐ڂ̃t@CɎ^Ă܂B
//   *2 Œdbԍ͔ԍ|e[uɂāAS̎sOǔԂ𒉎ɔ肵܂B
//-------------------------------------------------------------------------------
//   y T|[gĂdbԍ z
//       Œdb       10(擪 0) [ 0ABCDE-FGHJ ]
//       gѓdb       11(擪 070/080/090) [ 0x0-CDEF-GHJK , C:1-9 ] :060͎{
//       Mۋ       10(擪 0120) [ 0120-DEF-GHJ ]
//       Mۋ       11(擪 0800) [ 0800-DEF-GHJK ]
//       hodb       11(擪 050)  [ 050-CDEF-GHJK , C:1-9 ]
//       lQl         11(擪 020x) [ 020-CDE-FGHJK , C:1-3,5-9 ]
//       |Px       11(擪 0204) [ 020-4DE-FGHJK ]
//       elb         11(擪 0600) [ 0600-DEF-GHJK ]
//       񗿑㗝 10(擪 0990) [ 0990-DEF-GHJ ]
//       Sԍ   10(擪 0570) [ 0570-DEF-GHJ ]
//-------------------------------------------------------------------------------

// ԍ|e[u(2022/7/1 )
//   Œdb̑S̋ǔ(sOǔԁ{sǔ)ьgѓdb(070/080/090)̋ǔԂ
//   ^ĂJSONt@C(AreaCode4JSON.json)Kvŏ̓eɕҏWĂ܂B
//   Sł̃tH[}bg [ http://addinbox.sakura.ne.jp/Excel_Tips29.htm ] QƂ̎B
//   AJavaScriptpf[^JSONt@C쐬c[ňꏏɍ쐬Ă܂̂ŁA
//  uzf[^v̓ꐫ/m͕ۏႵ܂B
//
var AreaCodeArray =
{
  "AreaCodeList":{
    "Update":"2022-07-01",
    "AreaCode":[
      {"Tree":[0,1,22,41,42,54,69,70,81,114]},          {"Tree":[0,-3,2,4,7,10,15,19,20,21]},                      {"Tree":[-103,0,0,-4,-4,-4,3,0,0,0]},
      {"Tree":[0,0,-4,-4,-4,-4,-4,-5,0,0]},             {"Tree":[0,0,0,-4,-4,-4,-4,5,-4,6]},                       {"Tree":[0,0,-5,0,-5,-4,-4,-5,-4,0]},
      {"Tree":[0,0,-5,-4,-4,-4,-4,-5,-5,0]},            {"Tree":[0,0,-4,-4,-4,8,9,0,0,0]},                         {"Tree":[0,0,-4,-4,-4,0,-5,-5,0,0]},
      {"Tree":[0,0,-4,-4,-4,-4,-5,0,0,0]},              {"Tree":[0,0,-4,-4,11,12,13,-4,14,0]},                     {"Tree":[0,0,-4,-4,-4,-4,-4,-5,-3,-4]},
      {"Tree":[0,-3,-4,-4,-4,-4,-4,-3,-5,-4]},          {"Tree":[0,0,-4,-4,-5,0,-4,-4,0,0]},                       {"Tree":[0,0,-4,-4,-4,-4,-5,-5,-4,0]},
      {"Tree":[0,0,-4,16,17,18,-4,-4,0,0]},             {"Tree":[0,0,-5,0,-5,-5,-4,0,-4,-4]},                      {"Tree":[0,0,-4,-4,-4,-4,-4,0,-5,0]},
      {"Tree":[0,0,-4,-4,-5,-5,-5,0,-5,0]},             {"Tree":[0,0,-4,-4,-4,-4,-4,-3,-4,-4]},                    {"Tree":[0,0,-4,-4,-4,-4,-4,-4,-3,0]},
      {"Tree":[0,-4,-4,-4,-4,-4,-3,-4,-4,-3]},          {"Tree":[130,0,23,25,26,27,32,34,36,39]},                  {"Tree":[-4,0,-3,24,-4,-4,-4,-3,-4,-4]},
      {"Tree":[-3,0,-4,-4,-3,-3,-3,-3,-3,-3]},          {"Tree":[0,0,0,-4,-4,-4,-3,-4,-4,0]},                      {"Tree":[-4,-4,-4,-4,-4,-3,-4,-4,-4,-3]},
      {"Tree":[-4,0,-3,-3,-4,28,29,30,31,-4]},          {"Tree":[-3,-3,-3,-3,-3,-3,-3,-4,-4,-3]},                  {"Tree":[-3,0,0,-4,-4,-4,-4,-4,-4,-4]},
      {"Tree":[-3,-3,-4,-4,-4,-3,-3,-3,-3,-3]},         {"Tree":[-3,0,-4,-4,-4,-4,-4,-4,-4,-4]},                   {"Tree":[-4,-4,-3,-4,33,-4,-4,-4,-4,-4]},
      {"Tree":[-3,0,-4,-4,-4,-4,-3,-3,-3,0]},           {"Tree":[-4,0,-3,-3,-4,0,-4,-4,35,-4]},                    {"Tree":[0,0,-4,-4,0,-4,-4,-4,-3,-3]},
      {"Tree":[-4,0,-4,37,-4,-4,-3,-4,-4,38]},          {"Tree":[-3,0,-4,-3,-3,-4,-4,0,-4,-4]},                    {"Tree":[-3,0,0,0,0,-3,-4,-4,-4,-4]},
      {"Tree":[0,-4,-3,40,-4,-4,-4,-4,-3,-4]},          {"Tree":[-3,0,-4,-4,-4,-3,-3,0,-3,0]},                     {"Tree":[0,0,0,-2,-2,-2,-2,0,0,0]},
      {"Tree":[0,0,43,47,-3,-3,48,49,51,52]},           {"Tree":[-2,0,44,-3,-3,-3,-3,-3,45,46]},                   {"Tree":[-3,0,-4,-4,-4,-4,-4,-4,-4,-4]},
      {"Tree":[-3,-3,-4,-4,-3,-3,-3,-4,-4,0]},          {"Tree":[-2,-3,-2,-2,-2,-2,-2,-3,-3,-2]},                  {"Tree":[0,0,-3,-3,-3,0,-4,0,-4,-4]},
      {"Tree":[-4,0,-3,-4,-3,-4,-4,-4,-3,0]},           {"Tree":[50,-2,0,-3,-3,-4,-4,-3,-4,-4]},                   {"Tree":[-2,0,-4,-4,-4,-4,-4,-4,-4,-2]},
      {"Tree":[-4,0,-3,0,-3,-3,-3,-3,-3,-3]},           {"Tree":[0,0,-3,-4,-4,-4,0,0,0,53]},                       {"Tree":[0,0,-5,0,-5,0,-5,0,-5,0]},
      {"Tree":[131,0,-3,55,59,60,61,62,64,65]},         {"Tree":[0,-4,-4,-4,-3,-3,-4,-4,-4,56]},                   {"Tree":[0,0,-3,0,0,0,57,58,-3,0]},
      {"Tree":[0,-4,-4,-4,-3,-3,-3,-3,-3,-3]},          {"Tree":[0,0,0,-3,-4,0,0,-4,0,0]},                         {"Tree":[0,0,-3,-3,-4,-4,-3,-4,-4,-3]},
      {"Tree":[-4,-4,-3,-4,-4,-4,-4,-4,-4,-3]},         {"Tree":[0,-4,-4,-4,-4,-4,-4,-4,-4,-4]},                   {"Tree":[-110,0,-4,-4,-4,-4,63,-4,-4,0]},
      {"Tree":[0,0,-4,-4,-4,-4,-4,-4,0,-5]},            {"Tree":[0,-4,-3,-3,-4,-4,-4,-4,0,0]},                     {"Tree":[0,0,-3,-3,-4,-4,-4,66,-4,68]},
      {"Tree":[0,0,-4,-4,-4,0,0,-4,-4,67]},             {"Tree":[0,0,-5,-5,-5,-5,-5,-4,-4,-5]},                    {"Tree":[0,0,-4,-4,-4,-4,-4,-4,-4,-3]},
      {"Tree":[132,0,0,0,-2,0,-2,-2,0,0]},              {"Tree":[133,0,71,72,73,-3,75,76,-3,77]},                  {"Tree":[0,-4,-3,-3,-3,-4,-3,-3,-3,-3]},
      {"Tree":[0,0,0,0,-3,-4,-4,-4,-4,-4]},             {"Tree":[-4,0,-4,-4,-4,-4,74,-4,-4,-4]},                   {"Tree":[0,0,0,-4,-4,-4,-4,0,-5,0]},
      {"Tree":[0,-4,-3,-4,-3,-4,-4,-4,-4,0]},           {"Tree":[-4,-4,-4,-4,-4,-3,-4,0,-4,-4]},                   {"Tree":[-4,-4,-3,-3,78,79,80,-4,-4,-4]},
      {"Tree":[0,0,-3,-3,-3,-3,-4,-4,-4,-3]},           {"Tree":[-3,0,-4,-4,-4,-3,-3,-4,-4,-3]},                   {"Tree":[-3,0,-4,-4,-4,-4,-3,-3,-4,-4]},
      {"Tree":[134,0,82,87,94,96,98,111,112,113]},      {"Tree":[-4,0,-3,-4,83,-3,-4,-4,-3,84]},                   {"Tree":[-3,0,-3,-3,-4,-4,-4,-4,-4,-3]},
      {"Tree":[-3,0,85,-4,86,-4,-3,-4,-4,0]},           {"Tree":[-4,-3,-3,-3,-3,-3,-3,-3,-3,-3]},                  {"Tree":[-4,-3,-3,-3,-4,-4,0,0,0,0]},
      {"Tree":[0,0,-3,-4,-4,-4,88,89,91,92]},           {"Tree":[-3,0,-4,-4,-4,-4,-4,-4,-4,-4]},                   {"Tree":[0,0,-4,-4,-4,-4,90,-3,-3,0]},
      {"Tree":[-4,0,-4,-4,-4,-4,-3,-3,-3,-4]},          {"Tree":[0,0,-4,-4,-4,-4,0,-5,-5,0]},                      {"Tree":[-3,0,-3,-3,-3,-3,93,-3,-3,-3]},
      {"Tree":[0,0,-5,-3,0,-5,-3,-5,-5,0]},             {"Tree":[0,0,0,0,0,-4,-4,95,-4,-3]},                       {"Tree":[0,0,-4,-4,-4,-4,-4,-5,-4,0]},
      {"Tree":[0,97,-4,-4,-4,-4,-4,-4,-4,-4]},          {"Tree":[0,0,-5,0,-5,0,0,0,0,0]},                          {"Tree":[0,0,-3,99,-3,101,103,105,108,109]},
      {"Tree":[0,0,-4,-4,-4,-4,100,-4,-4,0]},           {"Tree":[0,0,-3,-3,-3,0,-4,0,-3,0]},                       {"Tree":[0,0,-3,0,-4,102,-4,-4,0,0]},
      {"Tree":[-4,0,-3,0,-4,0,0,0,-4,0]},               {"Tree":[-3,0,-4,-4,-4,-4,-4,-4,-4,104]},                  {"Tree":[-4,-3,-4,-4,-4,-4,-4,-3,-3,-4]},
      {"Tree":[0,0,106,107,-4,-4,-4,-4,-4,-4]},         {"Tree":[0,0,-3,-3,-3,-4,-3,-4,-3,0]},                     {"Tree":[0,0,0,-4,-4,-4,-4,-3,-3,0]},
      {"Tree":[-3,0,-4,-4,-4,-4,-4,-4,-4,-3]},          {"Tree":[-3,0,-4,-4,-3,-3,-4,-4,-4,110]},                  {"Tree":[0,0,-4,-4,0,-3,0,-3,0,-3]},
      {"Tree":[0,0,0,0,0,-4,0,-4,-3,-4]},               {"Tree":[-4,0,0,-4,-4,-4,-3,-4,-3,-4]},                    {"Tree":[0,0,-4,-4,-4,-4,-4,-4,-4,-3]},
      {"Tree":[135,0,115,116,117,118,119,120,121,123]}, {"Tree":[-4,0,-3,-3,-3,-3,-3,-3,-3,-3]},                   {"Tree":[-4,0,-3,-3,-3,-3,-3,-3,-3,-3]},
      {"Tree":[-4,0,-4,-4,-4,0,-4,-4,-4,-4]},           {"Tree":[-4,0,-4,0,-4,-4,-4,-4,-3,-4]},                    {"Tree":[0,0,-3,-3,-4,-4,-4,-4,-4,-4]},
      {"Tree":[0,0,-4,-4,-4,-3,0,-4,-4,-4]},            {"Tree":[122,0,-4,-4,-4,-4,-4,-4,-3,-3]},                  {"Tree":[0,0,-5,-4,-4,-4,-4,-4,-4,-4]},
      {"Tree":[-109,124,-3,125,128,-4,129,-4,-3,0]},    {"Tree":[0,0,-5,-5,0,0,0,0,0,0]},                          {"Tree":[0,0,-4,126,127,-4,-4,-4,-4,0]},
      {"Tree":[0,-3,-4,-4,-4,-4,-4,-4,-4,-4]},          {"Tree":[-4,-4,0,-3,0,-3,0,-3,0,-4]},                      {"Tree":[-3,0,-4,-4,-4,-4,-4,-3,-3,-4]},
      {"Tree":[0,0,-4,-4,-4,-4,-4,-4,-4,-5]},           {"Tree":[0,-106,-106,-106,-107,-106,-106,-106,-106,-106]}, {"Tree":[0,-105,-105,-105,-105,-105,-105,-105,-105,-105]},
      {"Tree":[-108,0,0,0,0,0,0,0,0,0]},                {"Tree":[0,-102,-102,-102,-102,-102,-102,-102,-102,-102]}, {"Tree":[-104,-102,-102,-102,-102,-102,-102,-102,-102,-102]},
      {"Tree":[0,-102,-102,-102,-102,-102,-102,-102,-102,-102]}

    ]
  }
};


//-------------------------------------------------------------------------------
// dbԍ̃tH[}bg ( PhoneNumber )
//    --- ValidateTelephone/FormatTelephone ̊ȈՃC^[tF[X ---
//
// TelCode -- p[ 0-9, -, (, ) ]
//            Œdb/gѓdbȂǂ[nCt/]ҏW or ҏWdbԍ
//
// Action  -- "V"        : dbԍ̌
//            "F1"`"F6" : dbԍ̋؂ҏW( 2ڂ EditType ̒l )
//
// ԋpl
//    Action= "V"        -- 0: ؃G[ , 1:OK , 2:OK(dbԍ̂)
//                            (Boolean ϊ 0False, 1/2True ɂȂ܂)
//
//          = "F1"`"F6" -- dbԍꍇ: EditType(2)ɏ]ĕҏWdbԍ
//                          dbԍĂꍇ: "Phone Error"
//
//          LȊO     -- "" (BooleanϊFalse)ŕԂ܂B
// 
//-------------------------------------------------------------------------------
function PhoneNumber(TelCode, Action) {

    // FormatTelephone/ValidateTelephone ̕ԋpl
    var Result = InitTelephone("Value");

    var patternAction = /^(([Ff][1-6])|[Vv])$/;  // "F1"`"F6" or "V"

    if (Action === undefined) {
        return "";
    } else if (typeof Action != "string") {
        return "";
    } else {
        if (Action.match(patternAction) == null) {
            return "";
        }
    }

    if (TelCode === undefined) {
        return "";
    } else if (typeof TelCode != "string") {
        return "";
    }

    if (Action.toUpperCase() == "V") {
        Result = ValidateTelephone(TelCode);
        switch (Result.ErrId) {
            case 0:
                return 1;  // OK(BooleanϊTrue)
            case 8:
                return 2;  // OK (dbԍ̂, BooleanϊTrue)
            default:
                return 0;  // G[(BooleanϊFalse)
        }
    } else {
        Result = FormatTelephone(TelCode, Number(Action.substr(1)) );
        if (Result.ErrId == 0) {
            return Result.TelEdit;
        } else {
            return "Phone Error";
        }
    }
}


//-------------------------------------------------------------------------------
// ԋpl󂯎ϐɘAzz̏ݒ ( InitTelephone )
// 
// Target -- "Value" or "Type" (LȊO "Value" )
//
// ԋpl -- Target = "Value" ̏ꍇAL̘Azz
//              {"TelType":-1, "EditType":9, "TelEdit":"", "ErrId":0}
//           Target = "Type" ̏ꍇAL̘Azz
//              {"TelType":-1, "SizeAll":0, "Size1":0, "Size2":0, "Size3":0, "ErrId":0}
//-------------------------------------------------------------------------------
function InitTelephone(Target) {
    var Target2 = "";

    if (Target === undefined) {
        Target2 = "Value";
    } else if (typeof Target != "string") {
        Target2 = "Value";
    } else {
        if (Target.toUpperCase() == "VALUE") {
            Target2 = "Value";
        } else if (Target.toUpperCase() == "TYPE") {
            Target2 = "Type";
        } else {
            Target2 = "Value";
        }
    }

    if (Target2 == "Value") {
        return {"TelType":-1, "EditType":9, "TelEdit":"", "ErrId":0};
    } else {
        return {"TelType":-1, "SizeAll":0, "Size1":0, "Size2":0, "Size3":0, "ErrId":0};
    }
}


//-------------------------------------------------------------------------------
// dbԍ̌ ( ValidateTelephone )
//
// TelCode -- p[ 0-9, -, (, ) ]
//            Œdb/gѓdbȂǂ[nCt/]ҏW
//
// ԋpl  -- {TelType, EditType, TelEdit, ErrId} ̘Azz
//   TelType   1:Œdb(10), 2:gѓdb(070/080/090,11), 3:Mۋ(0120,10), 
//             4:Mۋ(0800,11), 5:IPdb(050,11), 6:M2M(020x,11,x4), 
//             7:|Px(0204,11), 8:FMC(0600,11), 9:񗿒(0990,10), 
//             10:ԍ(0570,10), -1:other
//
//   EditType  1or4: 0AB-CDE-FGHJ, 2or5: 0AB(CDE)FGHJ, 3or6: (0AB)CDE-FGHJ, 9:other
//             gѓdb̂݁A[3-4-4 ]ŋ؂1`3 , [3-3-5 ]ŋ؂4`6
//
//   TelEdit   TelType/EditType ŕҏWꂽdbԍ(ҏW)
//               ErrId=0/1/3/5 : p^[ŕҏWꂽdbԍ
//                 V =8       : nCtҏWdbԍ
//                 V =2       : TelCode ̂܂(gpǔԂȂ̂Ő͔fȂ)
//                 V =4/6/9   : 󕶎
//
//   ErrId     0:OK, 1:؂ʒus, 2:gpǔ(Œdb), 3:sǔ1ڂ[0 or 1](Œdb),
//             4:s([,nCt,]ȊO or ҏWp^[s or '0'n܂łȂ or s), 
//             5:s(ǔԃ^Cvɉƕsv),
//             6:̑̃G[, 8:OK(̂ݎw), 9:`(TelCode)
//-------------------------------------------------------------------------------
function ValidateTelephone(TelCode) {

    // ԋpl
    var Result = InitTelephone("Value");

    // FormatTelephone̕ԋpl
    var ResultFormat = InitTelephone("Value");
    // gѓdb(3-3-5؂ҏW̍Ď擾p)
    var ResultFormat2 = InitTelephone("Value");

    var strTelCode;   // JavaScriptɂ͈Ɍ^w肪̂Ń`FbNϊ
    var TelNumber;    // nCt,ʏ(̂)
    var EditType;

    // ȃ`FbN FormatTelephone ̌ʂƔrčsȂ̂
    // L̃p^[`FbNł͌ɂĂ͞Bō\Ȃ('0'n܂̂݃`FbN)
    var pattern0 = /^0\d+$/;            // 0123456789
    var pattern1 = /^0\d+-\d+-\d+$/;    // 012-345-6789
    var pattern2 = /^0\d+\(\d+\)\d+$/;  // 012(345)6789
    var pattern3 = /^\(0\d+\)\d+-\d+$/; // (012)345-6789

    if (TelCode === undefined) {
        Result.ErrId = 9;
        return Result;
    } else if (typeof TelCode == "string") {
        strTelCode = TelCode;
    } else if (typeof TelCode == "number") {  // l̏ꍇA擪'0'̂FormatTelephoneŃG[Ԃ
        strTelCode = String(TelCode);
    } else {
        Result.ErrId = 9;
        return Result;
    }

    if (strTelCode.match(pattern0) != null) {  // (̂)  0123456789
        // ̂ݎw  ҏŴݍsĔr؂͖
        ResultFormat = FormatTelephone(strTelCode, 1);  // nCtҏWŌŒ
        Result.TelType = ResultFormat.TelType;
        Result.EditType = 1;
        Result.TelEdit = ResultFormat.TelEdit;
        // ValidateTephonepG[R[hɍւ
        switch (ResultFormat.ErrId) {
            case 0:
                Result.ErrId = 8;  // OK(̂ݎw)
                break;
            case 1:
                Result.ErrId = 2;  // gpǔ(Œdbԍ)
                break;
            case 2:
                Result.ErrId = 3;  // sǔ1ڂ[0 or 1](Œdb)
                break;
            case 3:
                Result.ErrId = 4;  // s(10)
                break;
            case 4:
                Result.ErrId = 5;  // ǔԃ^Cvɉƕsv
                break;
            default:
                Result.ErrId = 6;  // ̑̃G[
        }
        return Result;
    } else if (strTelCode.match(pattern1) != null) {  // EditType:1  012-345-6789
        EditType = 1;
        Result.EditType = 1;
    } else if (strTelCode.match(pattern2) != null) {  // EditType:2 012(345)6789
        EditType = 2;
        Result.EditType = 2;
    } else if (strTelCode.match(pattern3) != null) {  // EditType:3 (012)345-6789
        EditType = 3;
        Result.EditType = 3;
    } else {
        // [,nCt,]ȊO or ҏWp^[s or '0'n܂łȂ
        Result.ErrId = 4;
        Result.TelEdit = strTelCode;
        return Result;
    }

    // FormatTelephone p[nCt,]āû݁vɂ
    TelNumber = strTelCode.replace(/-|\(|\)/g,"");

    ResultFormat = FormatTelephone(TelNumber, EditType);
    // FormatTelephone ŕҏWʂƔrČ؂
    // ErrId ŕԂ̂
    //    0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb)
    //    3:s(TelCode: 10), 
    //    4:s(TelCode: ǔԃ^Cv̌ƕsv)
    // LԂ͊Ƀ`FbNςȂ̂ŁA̒lԂ邱Ƃ͖
    //    3:s(TelCode: ['0'n܂̐]ȊO)
    //    6:s(EditType)
    //    9:`(TelCode/EditType)

    Result.TelType = ResultFormat.TelType;
    Result.TelEdit = ResultFormat.TelEdit;
    // ValidateTephonepG[R[hɍւ
    switch (ResultFormat.ErrId) {
        case 0:  // FormatTelephoneOK  dbԍ
            if (strTelCode == ResultFormat.TelEdit) {
                Result.ErrId = 0;  // OK (؂ʒu)
            } else {
                if (ResultFormat.TelType == 2) { // gѓdb(070/080/090)
                    // gѓdb̏ꍇAʂ̋؂[3-3-5 ]ōă`FbN
                    ResultFormat2 = FormatTelephone(TelNumber, EditType + 3);
                    if (strTelCode == ResultFormat2.TelEdit) {
                        // OK (3-3-5ňv)
                        Result.ErrId = 0;
                        Result.TelEdit = ResultFormat2.TelEdit;
                        Result.EditType = EditType + 3;
                    } else {
                        Result.ErrId = 1;  // ؂ʒus
                    }
                } else {
                    // gѓdb ȊO
                    Result.ErrId = 1;  // ؂ʒus
                }
            }
            break;
        case 1:
            Result.ErrId = 2;  // gpǔ(Œdbԍ)
            Result.TelEdit = TelCode;  // ResultFormat.TelEdit(=TelNumber)Ȃ̂œ͒lɍւ
            break;
        case 2:
            Result.ErrId = 3;  // sǔ1ڂ[0 or 1](Œdb)
            break;
        case 3:
            Result.ErrId = 4;  // s(10)
            break;
        case 4:
            Result.ErrId = 5;  // ǔԃ^Cvɉƕsv
            break;
        default:
            Result.ErrId = 6;  // ̑̃G[
    }
    return Result;
}


//-------------------------------------------------------------------------------
// dbԍ̃nCtҏW ( FormatTelephone )
//
// TelCode  -- p[ 0-9 ], 10 or 11(擪'0'Œ)
//             Œdb/gѓdbȂǂ̓dbԍ
//
// EditType -- l
//             1or4: 0AB-CDE-FGHJ , 2or5: 0AB(CDE)FGHJ , 3or6: (0AB)CDE-FGHJ
//             gѓdb̂݁A[3-4-4 ]ŋ؂1`3 , [3-3-5 ]ŋ؂4`6
//
// ԋpl -- {TelType, EditType, TelEdit, ErrId} ̘Azz
//   TelType   1:Œdb(10), 2:gѓdb(070/080/090,11), 3:Mۋ(0120,10), 
//             4:Mۋ(0800,11), 5:IPdb(050,11), 6:M2M(020x,11,x4), 
//             7:|Px(0204,11), 8:FMC(0600,11), 9:񗿒(0990,10), 
//             10:ԍ(0570,10), -1:other
//
//   EditType  1or4: 0AB-CDE-FGHJ, 2or5: 0AB(CDE)FGHJ, 3or6: (0AB)CDE-FGHJ, 9:other
//
//   TelEdit   ҏWꂽdbԍ
//               ErrId=0/2/4 : ҏWꂽdbԍ
//                V  =1     : TelCode ̓ê܂
//                V  =3/6/9 : 󕶎
//
//   ErrId     0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb),
//             3:s(TelCode: ['0'n܂̐]ȊO or 10), 
//             4:s(TelCode: ǔԃ^Cvɉƕsv)
//             6:s(EditType), 9:`(TelCode/EditType)
//-------------------------------------------------------------------------------
function FormatTelephone(TelCode, EditType) {

    // ԋpl
    var Result = InitTelephone("Value");

    // GetTypeTelephone ԋpl
    var ResultType = InitTelephone("Type");

    var strTelCode;  // JavaScriptɂ͈Ɍ^w肪̂Ń`FbNϊ
    var intEditType;

    var TelPattern = /^0\d{9,}$/;      // '0'n܂̐(10ȏ)
    var EditTypePattern = /^[1-6]$/;   // '1' ` '6'(1)

    if (TelCode === undefined) {
        Result.ErrId = 9;
        return Result;
    } else if (typeof TelCode == "string") {
        strTelCode = TelCode;
    } else if (typeof TelCode == "number") {
        strTelCode = String(TelCode);  // l̏ꍇA擪'0'̂Ŏ̔ŃG[ŕԂ
    } else {
        Result.ErrId = 9;
        return Result;
    }

    // ['0'n܂̐(10ȏ)]̃`FbN
    // (ԍ|(GetTypeTelephone)ɊSȌ`FbNsȂBł10̂NG)
    if (strTelCode.match(TelPattern) == null) {
        Result.ErrId = 3;
        return Result;
    }

    if (EditType === undefined) {
        Result.ErrId = 9;
        return Result;
    } else if (typeof EditType == "string") {
        if (EditType.match(EditTypePattern) != null) {
            intEditType = Number(EditType);
        } else {
            Result.ErrId = 6;
            return Result;
        }
    } else if (typeof EditType == "number") {
        if (EditType >= 1 && EditType <= 6) {
            intEditType = EditType;
        } else {
            Result.ErrId = 6;
            return Result;
        }
    } else {
        Result.ErrId = 6;
        return Result;
    }
    Result.EditType = intEditType;

    ResultType = GetTypeTelephone(strTelCode);  // ԍ|󂵂ēdbԍ̎ʂƌ؂擾
    // ErrId ŕԂ̂
    //    0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb)
    // LԂ͊Ƀ`FbNςȂ̂ŁA̒lԂ邱Ƃ͖
    //    3:dbԍʂs(sŔԍ|󖢗) 10ȏȂ̂Ŗ͖
    //    8:s(TelCode: ['0'n܂̐]ȊO)
    //    9:`(TelCode)

    Result.TelType = ResultType.TelType;
    Result.ErrId = ResultType.ErrId;
    if (ResultType.ErrId == 1) {
        // gpǔ(Œdb)
        Result.TelEdit = strTelCode;
    } else {
        // 0:OK  or  2:sǔ1ڂ[0 or 1](Œdb)
        if (ResultType.TelType == 2 && intEditType >= 4) {
            // gѓdb(070/080/090)[3-3-5 ؂, 0x0-CDE-FGHJK]w肳ꂽꍇ
            Result.TelEdit = InsertSeparator(strTelCode, intEditType, 3, 3);
        } else {
            // gѓdb(3-4-4؂)܂߁A͕ԋplŋ؂p^[
            // Œdbł[sOǔԌ/sǔԌ/Ҕԍ(4)]
            if (ResultType.Size2 == 0) {
                // ŒdbŁAsǔԂȂ [ 0ABCDE-FGHJ ] (݁A̒n݂͑Ȃ)
                Result.TelEdit  = strTelCode.substr(0, 6) + "-" + strTelCode.substr(6);
            } else {
                Result.TelEdit = InsertSeparator(strTelCode, intEditType, ResultType.Size1, ResultType.Size2);
            }
        }

        if (strTelCode.length != ResultType.SizeAll) {
            Result.ErrId = 4;  // G[(ǔԃ^Cvɉƕsv)
        }
    }

    return Result;
}

function InsertSeparator(TelCode, EditType, Size1, Size2) {
    var Result;
    var EditCode1 = TelCode.substr(0, Size1);      // 1st section FŒdbł͎sOǔ(擪'0')
    var EditCode2 = TelCode.substr(Size1, Size2);  // 2nd section FŒdbł͎sǔ
    var EditCode3 = TelCode.substr(Size1 + Size2); // 3rd section FŒdbł͉Ҕԍ(܂Ŏo)

    switch (EditType) {
        case 1:  // 0AB-CDE-FGHJ
        case 4:
            Result = EditCode1 + "-" + EditCode2 + "-" + EditCode3;
            break;
        case 2:  // 0AB(CDE)FGHJ
        case 5:
            Result = EditCode1 + "(" + EditCode2 + ")" + EditCode3;
            break;
        case 3:  // (0AB)CDE-FGHJ
        case 6:
            Result = "(" + EditCode1 + ")" + EditCode2 + "-" + EditCode3;
    }
    return Result;
}


//-------------------------------------------------------------------------------
// dbԍ^Cv̎擾 ( GetTypeTelephone )
//
// TelCode  -- p(2ȏ, 擪'0'Œ)
//             Œdb/gѓdbȂǂ̓dbԍ(r܂ł̓eł)
//
// ԋpl -- {TelType, SizeAll, Size1, Size2, Size3, ErrId} ̘Azz
//   TelType   1:Œdb(10), 2:gѓdb(070/080/090,11), 3:Mۋ(0120,10), 
//             4:Mۋ(0800,11), 5:IPdb(050,11), 6:M2M(020x,11,x4), 
//             7:|Px(0204,11), 8:FMC(0600,11), 9:񗿒(0990,10), 
//             10:ԍ(0570,10), -1:other
//
//   SizeAll   ErrId=0/2 : TelType ɉdbԍ̌(10 or 11, Size1`3̍vl)
//             ErrId=1/3/8/9 : 0
//
//   Size1-3   ErrId=0/2 : TelType ɉdbԍ̋؂茅(Size1 ɂ͐擪'0'܂)
//             ErrId=1/3/8/9 : 0
//             (gѓdb(TelType=2)[3-4-4 ؂]݂̂ŕԂ)
//
//   ErrId     0:OK, 1:gpǔ(Œdb), 2:sǔ1ڂ[0 or 1](Œdb),
//             3:dbԍʂs(sŔԍ|󖢗)
//             8:s(TelCode: ['0'n܂̐]ȊO), 9:`(TelCode)
//-------------------------------------------------------------------------------
function GetTypeTelephone(TelCode) {

    // ԋpl
    var Result = InitTelephone("Type");

    var strTelCode;  // JavaScriptɂ͈Ɍ^w肪̂Ń`FbNϊ

    var AreaCodeLength;
    var CityCodeLength;
    var CityCode1;      // sǔԂ1
    var idx;
    var cnt;
    var num;
    var LinkValue;
    var TelType;
    var TelPattern = /^0\d+$/;      // '0'n܂̐(Ȃ)

    // ( 1)Œdb       10 [ ؂͔ԍ|󌋉ʂɋ ]
    // ( 2)gѓdb       11 [ 0x0-CDEF-GHJK , 070/080/090 ]
    // ( 3)Mۋ       10 [ 0120-DEF-GHJ  ]
    // ( 4)Mۋ       11 [ 0800-DEF-GHJK ]
    // ( 5)hodb       11 [ 050-CDEF-GHJK ]
    // ( 6)lQl         11 [ 020-CDE-FGHJK ]
    // ( 7)|Px       11 [ 020-4DE-FGHJK ]
    // ( 8)elb         11 [ 0600-DEF-GHJK ]
    // ( 9)񗿑㗝 10 [ 0990-DEF-GHJ  ]
    // (10)Sԍ   10 [ 0570-DEF-GHJ  ]
    //  SizeInfo [SizeAll, Size1, Size2, Size3]
    var SizeInfo = [
           [0,0,0,0],  [10,0,0,0], [11,3,4,4], [10,4,3,3], [11,4,3,4],
           [11,3,4,4], [11,3,3,5], [11,3,3,5], [11,4,3,4], [10,4,3,3], [10,4,3,3]
        ];

    if (TelCode === undefined) {
        Result.ErrId = 9;
        return Result;
    } else if (typeof TelCode == "string") {
        strTelCode = TelCode;
    } else if (typeof TelCode == "number") {
        strTelCode = String(TelCode);  // l̏ꍇA擪'0'̂Ŏ̔ŃG[ŕԂ
    } else {
        Result.ErrId = 9;
        return Result;
    }

    // ['0'n܂̐(Ȃ)]̃`FbN
    if (strTelCode.match(TelPattern) == null) {
        Result.ErrId = 8;
        return Result;
    }

    //  ԍ|e[u\[XR[hɒɎ^Ă̂
    //    jQuery ɂ JSONt@C̓ǂݍݏ͕KvȂB

    // ԍ|e[uǔԏ(sOǔԂ̌ or [gєԍ ]TelType)擾B
    // [TelCode]̒[ǔԌ ]󂯓Ă̂Łwԍ| rxł̃[vI(TelType= -1)B
    idx = 0;
    TelType = -1;
    AreaCodeLength = 0;
    for (cnt = 1; (cnt <= 5) && (cnt < strTelCode.length); cnt++) {  // ԍ|e[uA`ER[ĥTi
        num = Number(strTelCode.substr(cnt, 1));    // dbԍ2ڈȍ~(1ڂ'0')o
        LinkValue = AreaCodeArray.AreaCodeList.AreaCode[idx].Tree[num];
        if (LinkValue == 0) {   // ԍ| I(Œdb gpǔ)
            TelType = 1;
            AreaCodeLength = 0;
            break;
        } else if (LinkValue < 0) {  // ԍ| I
            if (LinkValue > -100) {
                // Œdb̎sOǔԌ(]l) ۂ̎^l[ -2 ` -5 ]
                TelType = 1;
                AreaCodeLength = LinkValue * (-1);  // sOǔ (擪 "0" ܂)
            } else {
                // gѓdb TelTypel(]l - 100) ۂ̎^l[ -102 ` -110 ]
                TelType = (LinkValue * (-1)) - 100;
            }
            break;
        } else {  // vXl
            idx = LinkValue;  // p(^l NextIndex)
        }
    }

    // TelType ɉ؂ݒ肷
    // Œdb(TelType=1)ł͎sOǔԌ(AreaCodeLength)ɏ]Đݒ肷
    // Size1 ̒l[擪'0'܂]
    Result.TelType = TelType;
    switch (TelType) {
        case -1:
            // dbԍʂs(sŔԍ|󖢗)
            Result.ErrId = 3;
            break;
        case 1:
            // Œdb
            if (AreaCodeLength == 0) {  // gp ǔ
                Result.ErrId = 1;
            } else if (AreaCodeLength == 6) {  // sǔԂȂ [ 0ABCDE-FGHJ ] (݁A̒n݂͑Ȃ)
                Result.ErrId = 0;
                Result.SizeAll = 10;
                Result.Size1 = 6;
                Result.Size2 = 0;
                Result.Size3 = 4;
            } else {
                CityCodeLength = 6 - AreaCodeLength;  // 10 - AreaCodeLength - 4(Ҕԍ)
                if (strTelCode.length < (AreaCodeLength + 1)) {
                    // [TelCode]sǔԂ̌ʒu܂łȂ̂ŎsǔԓKۂ̔s OK ŕԂ
                    Result.ErrId = 0;
                } else {
                    // FormatTelephone Ă΂ꍇ 10ȏȂ̂ŕK\
                    CityCode1 = strTelCode.substr(AreaCodeLength, 1);  // sǔ 1
                    if (CityCode1 == "0" || CityCode1 == "1") {
                        Result.ErrId = 2;  // sǔ1ڂ0/1͊蓖ĂȂ
                    } else {
                        Result.ErrId = 0;  // OK
                    }
                }
                Result.SizeAll = 10;
                Result.Size1 = AreaCodeLength;
                Result.Size2 = CityCodeLength;
                Result.Size3 = 4;
            }
            break;
        default:
            // TelType = 2`10, SizeInfoe[u猅ݒ肷
            Result.ErrId = 0;  // OK
            Result.SizeAll = SizeInfo[TelType][0];
            Result.Size1   = SizeInfo[TelType][1];
            Result.Size2   = SizeInfo[TelType][2];
            Result.Size3   = SizeInfo[TelType][3];
    }
    return Result;
}

